package it.eng.eremita.servlet;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.imageio.ImageIO;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import it.eng.eremita.graphql.types.Query;
import it.eng.eremita.graphql.types.SessionProvider;
import it.eng.eremita.jpa.entity.DatiBinari;
import it.eng.eremita.jpa.entity.Documento;
import it.eng.eremita.jpa.entity.Metadato;
import it.eng.eremita.jpa.entity.MetadatoHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioSpecie;
import it.eng.eremita.jpa.entity.Segnalazione;
import it.eng.eremita.jpa.entity.SegnalazioneAltreSpecie;
import it.eng.eremita.jpa.entity.Utente;
import it.eng.eremita.jpa.manager.Accessor;
import it.eng.eremita.jpa.manager.EremitaManager;

@WebServlet(urlPatterns = {"/csv/*"})
public class CSVReportServlet extends HttpServlet {
	
	public static final String SEPARATOR = "\t";
	public static final String EOL = "\r\n";
	

	public void init(ServletConfig servletConfig) throws ServletException {

	}
	
	public void doGet(HttpServletRequest request, HttpServletResponse response){
		   doPost(request, response);
		}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response){
		
		
		EremitaManager eremitaManager;
		
		try {
 			Properties props=new Properties();		
	        Context ctx = new InitialContext(props);
	        
	        eremitaManager = (EremitaManager)ctx.lookup(Accessor.eremitaManagerJndi);
	        if (eremitaManager==null) {
	        	response.sendError(500);
				return;
	        }

		} catch (Exception e ) {
			e.printStackTrace();
			try {
				response.sendError(500);
			}catch (Exception e2) {
				e2.printStackTrace();
			}
			return;
		}
		
		String uri = request.getRequestURI();
		String path[] = uri.split("/");
		String what = path[path.length-3];
		String filter = path[path.length-2];
		if (filter.equals("*")) filter = null;
		
		try {
			
			boolean thumbnail = uri.contains("thumbnail");
			
			try {
				Query q = new Query( new SessionProvider() {
					
					@Override
					public HttpServletRequest getRequest() {
						return request;
					}
				});
				
				String out = "";
				
				if ("monitoraggiSpecie".equals(what)) {
					List<MonitoraggioSpecie> l = q.monitoraggioSpecies2(filter, null, null);
					out = csvMonitoraggiSpecie(l);
				}
				
				if ("monitoraggiHabitat".equals(what)) {
					List<MonitoraggioHabitat> l = q.monitoraggioHabitat2(filter, null, null);
					out = csvMonitoraggiHabitat(l);
				}
				
				if ("utenti".equals(what)) {
					List<Utente> l = q.utentes2(filter, null, null);
					out = csvUtenti(l);
				}
				
				byte[] dati = out.getBytes();
				response.setContentType("text/csv");
				response.setContentLength(dati.length);
				response.setHeader("Cache-Control", "no-store");
				response.getOutputStream().write(dati);
				
				
			} catch (Exception e) {
				e.printStackTrace();
				response.sendError(500);
				return;
			}
			
	
			
			
		} catch (Exception e) {
			e.printStackTrace();
			//response.sendError(404);
		}
		
	}

	private static String sanitize(String in) {
		if (in==null) return "\"\"";
		String in2 = in.replaceAll("\"", "'");
		in2 = in2.replaceAll("\n", " ");
		in2 = in2.replaceAll("\r", "");
		return "\"" + in2 + "\"";
	}
	
	private static String outputHeader(ArrayList<String> a) {
		StringBuilder sb = new StringBuilder();
		for (int k=0; k<a.size(); k++) {
			sb.append(sanitize(a.get(k)));
			if (k<a.size()-1) sb.append(SEPARATOR);
		}
		
		return sb.toString();
	}
	
	private static String outputHeader(String[] a) {
		StringBuilder sb = new StringBuilder();
		for (int k=0; k<a.length; k++) {
			sb.append(sanitize(a[k]));
			if (k<a.length-1) sb.append(SEPARATOR);
		}
		
		return sb.toString();
	}
	
	public static String csvMonitoraggiSpecie(List<MonitoraggioSpecie> ms) {
		
		ArrayList<String> header = new ArrayList<String>();
		header.add("N. Scheda");
		header.add("Validata");
		header.add("Specie");
		header.add("Ente");
		header.add("SIC");
		header.add("Rilevatori");
		header.add("Tipologia rilievo");
		header.add("Transetto");
		header.add("Lunghezza");
		header.add("Comune");
		header.add("Localita");
		header.add("Inizio");
		header.add("Fine");
		header.add("Meteo inizio");
		header.add("Meteo fine");
		header.add("Temperatura aria");
		header.add("UR");
		header.add("Vento");
		header.add("Prof. min acqua");
		header.add("Prof. max acqua");
		header.add("Limpidezza");
		header.add("Temp. acqua inizio transetto");
		header.add("Temp. acqua fine transetto");
		header.add("pH acqua");
		header.add("Conducibilita'");
		header.add("Durezza");
		header.add("Note");
		header.add("Longitudine");
		header.add("Latitudine");
		header.add("ID habitat");
		header.add("M");
		header.add("F");
		header.add("MF");
		header.add("Esemplari totali");
		header.add("Stadio sviluppo");
		header.add("Marcatura");
		header.add("Ricattura");
		header.add("Note rilievo");
		header.add("Altre specie");
		
		StringBuilder sb = new StringBuilder();
		sb.append(outputHeader(header));
		sb.append(EOL);
		
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
		
		for (MonitoraggioSpecie mon: ms) {
			ArrayList<String> row = new ArrayList<String>();
			row.add(mon.getIdScheda());
			row.add(mon.getValidatoBoolean()!=null && mon.getValidatoBoolean()==true?"SI":"NO");
			row.add(mon.getSpecie()!=null?mon.getSpecie().getDenominazioneTaxon():null);
			row.add(mon.getEnte());
			row.add(mon.getSito()!=null?mon.getSito().getNome():null);
			row.add(mon.getRilevatore());
			row.add(mon.getTipologiaMonitoraggio()!=null?mon.getTipologiaMonitoraggio().getEtichetta():null);
			row.add(mon.getTransetto());
			row.add(mon.getLunghezzaTransetto()!=null?mon.getLunghezzaTransetto().toString():null);
			row.add(mon.getComune());
			row.add(mon.getLocalita());
			row.add(mon.getTimestampInizioRilievo()!=null?sdf.format(mon.getTimestampInizioRilievo()):null);
			row.add(mon.getTimestampFineRilievo()!=null?sdf.format(mon.getTimestampFineRilievo()):null);
			row.add(mon.getMeteoInizio()!=null?mon.getMeteoInizio().getEtichetta():null);
			row.add(mon.getMeteoFine()!=null?mon.getMeteoFine().getEtichetta():null);
			row.add(mon.getTemperaturaAria()!=null?mon.getTemperaturaAria().toString():null);
			row.add(mon.getUmiditaRelativa()!=null?mon.getUmiditaRelativa().toString():null);
			row.add(mon.getVento());
			
			row.add(mon.getProfonditaMinAcqua()!=null?mon.getProfonditaMinAcqua().toString():null);
			row.add(mon.getProfonditaMaxAcqua()!=null?mon.getProfonditaMaxAcqua().toString():null);
			row.add(mon.getLimpidezza()!=null?mon.getLimpidezza().getEtichetta():null);
			row.add(mon.getTemperaturaAcquaInizioTransetto()!=null?mon.getTemperaturaAcquaInizioTransetto().toString():null);
			row.add(mon.getTemperaturaAcquaFineTransetto()!=null?mon.getTemperaturaAcquaFineTransetto().toString():null);
			row.add(mon.getpH()!=null?mon.getpH().toString():null);
			row.add(mon.getConducibilita()!=null?mon.getConducibilita().toString():null);
			row.add(mon.getDurezza()!=null?mon.getDurezza().toString():null);
			row.add(mon.getNote());
			
			String base = outputHeader(row);
			List<Segnalazione> s = mon.getSegnalaziones();
			if (s.size()==0) {
				s = new ArrayList<Segnalazione>();
				s.add(new Segnalazione());
			}
			
			String altre = "";
			for (SegnalazioneAltreSpecie sas : mon.getSegnalazioneAltreSpecies()) {
				altre+=sas.getNote()+" ";
			}
			
			for (Segnalazione ss : s) {
				sb.append(base);
				sb.append(SEPARATOR);
				
				ArrayList<String> seg = new ArrayList<>();
				seg.add(ss.getCoordinataX()!=null?ss.getCoordinataX().toString():null);
				seg.add(ss.getCoordinataY()!=null?ss.getCoordinataY().toString():null);
				seg.add(ss.getIdHabitat());
				seg.add(ss.getEsemplariM()!=null?ss.getEsemplariM().toString():null);
				seg.add(ss.getEsemplariF()!=null?ss.getEsemplariF().toString():null);
				seg.add(ss.getEsemplariMF()!=null?ss.getEsemplariMF().toString():null);
				int totali = 0;
				if (ss.getEsemplariM()!=null) totali += ss.getEsemplariM().intValue();
				if (ss.getEsemplariF()!=null) totali += ss.getEsemplariF().intValue();
				if (ss.getEsemplariMF()!=null) totali += ss.getEsemplariMF().intValue();
				seg.add(""+totali);
				seg.add(ss.getStadioSviluppo()!=null?ss.getStadioSviluppo().getEtichetta():null);
				seg.add(ss.getIdMarcatura());
				seg.add(ss.getIdRicattura());
				seg.add(ss.getNote());
				seg.add(altre);
				
				sb.append(outputHeader(seg));
				sb.append(EOL);
			}
			

		}
		
		return sb.toString();
	}
	
	public static String csvMonitoraggiHabitat(List<MonitoraggioHabitat> ms) {
		if (ms.size()==0) return "";
		
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
		StringBuilder sb = new StringBuilder();
		
		HashMap<Metadato, Integer> header = new HashMap<>();
		int index = 0;
		for (MonitoraggioHabitat mh : ms) {
			if (mh.getMetadati()!=null) {
				for (MetadatoHabitat md : mh.getMetadati()) {
					if (!header.containsKey(md.getMetadato()))
						header.put(md.getMetadato(),index++);
				}
			}
		}
		
		String metadati[] = new String[header.size()];
		for (Metadato m : header.keySet())
			metadati[header.get(m)] = m.getDescrizione();
		
		String stringaHeaderMetadati = outputHeader(metadati);
		
		
		ArrayList<String> h2 = new ArrayList<String>();
		h2.add("N. Scheda");
		h2.add("Validata");
		h2.add("Specie");
		h2.add("Ente");
		h2.add("SIC");
		h2.add("Rilevatori");
		h2.add("Tipologia rilievo");
		h2.add("Transetto");
		h2.add("Lunghezza");
		h2.add("Comune");
		h2.add("Localita");
		h2.add("Inizio");
		h2.add("Fine");
		h2.add("Longitudine");
		h2.add("Latitudine");
		
		sb.append(outputHeader(h2));
		sb.append(SEPARATOR);
		sb.append(stringaHeaderMetadati);
		sb.append(EOL);
		
		for (MonitoraggioHabitat mon : ms) {
			
			String[] riga = new String[header.size()+15];
			int i = 0;
			riga[i++] = mon.getIdScheda();
			riga[i++] = mon.getValidatoBoolean()!=null && mon.getValidatoBoolean()==true? "SI" : "NO";
			riga[i++] = (mon.getSpecie()!=null?mon.getSpecie().getDenominazioneTaxon():null);
			riga[i++] = (mon.getEnte());
			riga[i++] = (mon.getSito()!=null?mon.getSito().getNome():null);
			riga[i++] = (mon.getRilevatore());
			riga[i++] = (mon.getTipologiaMonitoraggio()!=null?mon.getTipologiaMonitoraggio().getEtichetta():null);
			riga[i++] = (mon.getTransetto());
			riga[i++] = (mon.getLunghezzaTransetto()!=null?mon.getLunghezzaTransetto().toString():null);
			riga[i++] = (mon.getComune());
			riga[i++] = (mon.getLocalita());
			riga[i++] = (mon.getTimestampInizioRilievo()!=null?sdf.format(mon.getTimestampInizioRilievo()):null);
			riga[i++] = (mon.getTimestampFineRilievo()!=null?sdf.format(mon.getTimestampFineRilievo()):null);
			riga[i++] = (mon.getCoordinataX()!=null?mon.getCoordinataX().toString():null);
			riga[i++] = (mon.getCoordinataY()!=null?mon.getCoordinataY().toString():null);
			int ni = i;
			for (MetadatoHabitat hab : mon.getMetadati()) {
				riga[ni+header.get(hab.getMetadato())] = hab.getValore();
			}
			sb.append(outputHeader(riga));
			sb.append(EOL);
		}
		
		return sb.toString();
	}
	
	public static String csvUtenti(List<Utente> ms) {
		
		ArrayList<String> header = new ArrayList<String>();
		header.add("Cognome");
		header.add("Nome");
		header.add("Codice fiscale");
		header.add("Email");
		header.add("Ruolo");
		
		StringBuilder sb = new StringBuilder();
		sb.append(outputHeader(header));
		sb.append(EOL);
		
		for (Utente u : ms) {
			ArrayList<String> row = new ArrayList<String>();
			row.add(u.getCognome());
			row.add(u.getNome());
			row.add(u.getId());
			row.add(u.getEmail());
			row.add(u.getRuolo()!=null?u.getRuolo().getNomeEsteso():null);
			sb.append(outputHeader(row));
			sb.append(EOL);
		}
		
		return sb.toString();
	}
	
	
}

